#!/usr/bin/env python3

import re

def printall(results,header=False):
    if header:
        print("#"," ".join(key for key in results.keys()))
    print(" ".join(str(results[key]) for key in results.keys()))


def extractQEdata(filenames):
    """filenames is a list of filenames
extract energy information from QE output files"""
    results={}  # create an empty dictionary to store all stuff
    for filen in filenames: # loop over the files:
        f = open(filen, 'r')
        results.update({"filen":filen})

        interestingstuff=False
        for line in f:
            if re.search("convergence has been achieved in",line):
                interestingstuff=False
# print results here if need results at each relaxation step:
                printall(results)

            if interestingstuff: # here the actual processing is made:
                sline=re.sub("^\s+","",line).rstrip() # remove initial spaces and trailing newline
                nums=re.split('\s+',sline) # put the individial fields in nums
                if re.search("!    total energy",line):
                    toten=float(nums[4])
                    results.update({"toten":toten})
                if re.search("     one-electron contribution",line):
                    oneelen=float(nums[3])
                    results.update({"oneelen":oneelen})
                if re.search("     hartree contribution",line):
                    hartreeen=float(nums[3])
                    results.update({"hartreeen":hartreeen})
                if re.search("     xc contribution",line):
                    xcen=float(nums[3])
                    results.update({"xcen":xcen})
                if re.search("     ewald contributio",line):
                    ewalden=float(nums[3])
                    results.update({"ewalden":ewalden})
                if re.search("     smearing contrib",line):
                    smearingen=float(nums[4])
                    results.update({"smearingen":smearingen})
 # potentially collect more info, e.g. Fermi energy, magnetization...
 
            if re.search("End of self-consistent calculation",line):
                interestingstuff=True

# print results here if need results at the final step only:
        printall(results,True)
    return results    # return results if useful outside
        

# the following function is only exectuted when this code is run as a script:
if __name__ == "__main__":
    filenames = ["QE_first.out"]
    results=extractQEdata(filenames)
#   final printout:
#    print(results)
