#!/usr/bin/env python3

import re
import sys

def extractQEpos(args):
    """print out the atomic positions found in QE output files, in xyz format"""
    for filen in args.filenames: # loop over the files, open if needed:
        if args.debug:
            print(" debug: args=", args)
        if filen=="-":
            f=sys.stdin
        else:
            f = open(filen, 'r')

        frame=0
        interestingstuff=False
        for line in f:
            if re.search("Self-consistent Calculation",line):
                interestingstuff=False
            if re.search("number of atoms/cell  ",line):
                sline=re.sub("^\s+","",line).rstrip()
                nums=re.split('\s+',sline)
                natom=int(nums[4])  # record here the number of atoms
            if interestingstuff: # here the actual processing is made:
                sline=re.sub("^\s+","",line).rstrip() # remove initial spaces and trailing newline
                nums=re.split('\s+',sline) # put the individial fields in nums
                if args.debug:
                    print(" debug ", len(nums), " nums[0]: ",nums[0])
                if len(nums)==4:
                    print(sline)
                else:
                    interestingstuff=False  # no more atoms: leave
 
            if re.search("ATOMIC_POSITIONS",line):
# note that this works fine if the units are angstrom. However QE occasionally uses different units, thus one should take care of conversions...
                interestingstuff=True
                frame+=1
                print(natom)
                print("# positions extracted from",filen,", frame",frame)

    return frame    # return the number of printed-out frames
        

# the following function is only exectuted when this code is run as a script, and its purposes is to parse
# the command line and to generate a meaningful parsed args list for the actual function doing the job:
if __name__ == "__main__":
    import argparse
    commandname=sys.argv[0]

    desc="""Postprocessing of QE output files
INPUT : QE output file(s)
OUTPUT: atomic positions in xyz format"""

    epil="""v1.1 by N. Manini, 23.04.2020"""

    ##  Argument Parser definition:
    parser = argparse.ArgumentParser( formatter_class=argparse.ArgumentDefaultsHelpFormatter
                                    , description=desc, epilog=epil)

    parser.add_argument( 'filenames', nargs='*', default=['-'],
                         help='Files to be processed. If not given, stdin is used')
    parser.add_argument( '-d', '--debug', action='store_true',
                         dest='debug', 
                         help='activate debug mode -- WARNING! output is affected/spoiled!' )
    ## End arg parser definition
    args=parser.parse_args(sys.argv[1:])
    d = vars(args)	# adding prog in args, for unknown reasons it's not there...
    d['prog']=parser.prog

#   here we call the actual function doing the job:
    results=extractQEpos(args)  # NB! we pass args now, not just the filenames
#   final printout, better not, here!
#    print(results)
