reset

set terminal post eps enhanced color "Times-Roman" 23
set out 'semiconductor_n_p.eps

set style data lines
set style line 1 lt 6 lw 5 pt 3 ps 0.5
set style line 2 lt 7 lw 5 pt 3 ps 0.5
set style line 3 lt 1 lw 6 pt 3 ps 0.5

set border lw 2.0
set multiplot
set lmargin at screen 0.192
set rmargin at screen 0.99

set bmargin at screen 0.15
set tmargin at screen 0.6

set log y

set xla "T [K]"
set yla "carrier concentration [m^{-1}]"
set key right bottom

!semiconductor_carrier_concentration.py --ND 1.5e20 > /tmp/snp.dat

set label "Si,  N_D = 1.5x10^{20} m^{-3}" at 250,2e21 center

p[:799][5e17:5e22]'/tmp/snp.dat' us 1:3 ls 1 tit "n",'/tmp/snp.dat' us 1:4 ls 2 tit "p"


set bmargin at screen 0.6
set tmargin at screen 0.99

unset log y
unset xla
set yla "chem. pot. [eV]"
set xtics format ""
set ytics 0.5
set mytics 5
set key at 740,0.9

set object 1 rect from 0,-0.18 to 799,0 fc rgb "blue"
set label "valence band" at 799/2,-0.09 center textcolor rgb "white"
set object 2 rect from 0,1.1 to 799,1.28 fc rgb "gold"
set label "conduction band" at 799/2,1.19 center textcolor rgb "navy"

p[:799][-0.18:1.28]'/tmp/snp.dat' us 1:2 ls 3 tit "{/Symbol m}"

unset multiplot
set out
set term x11

!epstopdf semiconductor_n_p.eps
