/*
This software was developed by Alessio Del Monte and Nicola Manini. It is not
subject to copyright protection and is in the public domain: permission is
granted to any individual or institution to use, copy, modify or redistribute
it. The authors make no guarantees about this software and assume no
responsibility for its use by other parties.

Whoever makes use of it is asked to cite "A. Del Monte, N. Manini, L.G.
Molinari, and G.P. Brivio, Mol. Phys. 103, 689 (2005)" and the URL
http://materia.fisica.unimi.it/manini/ivr.html.

This license statement should be provided in derived software.
*/

#include <cassert>

namespace algo {


template <class T>
T factorial(T num) // return num! = num * (num-1) * (num-2) * ...* 1
{
  T prod = 1; 
  for (; num > 1; num--)
    {
      prod *= num;
    }
  return prod;
}

template <class T> 
std::size_t number_of_permutations(const T* begin, const T* end)
{
  std::size_t size = end - begin;
  assert(size > 0);

  T* array = new T[size];
  std::copy(begin, end, array);
  std::sort(array, array + size); 
 
  std::size_t  num = 1; // at less one 
  while(std::next_permutation(array, array + size) )
    num++;
  // next_permutation(): Sec. 18.10
  return num;
}   


} // namespace algo
