/*
This software was developed by Alessio Del Monte and Nicola Manini. It is not
subject to copyright protection and is in the public domain: permission is
granted to any individual or institution to use, copy, modify or redistribute
it. The authors make no guarantees about this software and assume no
responsibility for its use by other parties.

Whoever makes use of it is asked to cite "A. Del Monte, N. Manini, L.G.
Molinari, and G.P. Brivio, Mol. Phys. 103, 689 (2005)" and the URL
http://materia.fisica.unimi.it/manini/ivr.html.

This license statement should be provided in derived software.
*/

template<class T> // reads components of a vector of <T> from a string
std::vector<T> split(const char* c_str) 
{
  std::vector<T> vec;
  std::istringstream iss(c_str);
 
  T token;
  while(iss >> token)
    vec.push_back(token);
 
  return vec;
}


//********************** [I/O functions] **********************
//

template <class T> // eventually loop can be eliminated using
		   // algorithm for_each(), Sec. 18.5.1
std::ostream& operator<<(std::ostream& ostr, const std::vector<T>& vec) 
{
  size_t i;
  for(i = 0; i<vec.size() -1; i++) {
    ostr <<vec[i]<<' ';
  }
  return ostr <<vec[i];
}

template <class T>
std::istream& operator>>(std::istream& instr, std::vector<T>& vec)
{
  size_t i = 0;
  while(i< vec.size() && instr >> vec[i++]) ;
  for(i; i < vec.size(); i++)
    vec[i] = T(); // remaining values with default value T() (zero)
  return instr;
}


template <class T> 
std::ostream& operator<<(std::ostream& ostr, const std::valarray<T>& array) 
{
  size_t i;
  for(i = 0; i<array.size() - 1; i++) {
    ostr <<array[i]<<' ';
  }
  return ostr <<array[i];
}


template <class T>
std::istream& operator>>(std::istream& instr, std::valarray<T>& v)
{
  std::string line;
  std::getline(instr, line, '\n'); 
  // ev. change stopping character. see Sec. 20.3.15

  std::vector<T> buffvec =  split<T>(line.c_str());
 
  v.resize(buffvec.size());
  std::copy(buffvec.begin(), buffvec.end(), &v[0]);
  
  return instr;
}


